/*
 * @(#)Strings.java  1.3  2006-02-07
 *
 * Copyright (c) 2002-2006 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland
 * All rights reserved.
 *
 * Permission to use this software for non commercial purposes
 * is hereby granted without fee provided that the complete
 * copyright notice and this permission notice appear in all
 * copies and in supporting documentation.
 */
package ch.randelshofer.util;

import java.util.*;
/**
 * This class contains various methods for manipulating strings.
 *
 * @author Werner Randelshofer, Staldenmattweg 2, Immensee, CH-6405, Switzerland
 * @version 1.3 2006-02-07 Method split(String, char) added.
 * <br>1.2.1 2003-06-13 Method translate(String, char, char) removed.
 * <br>1.2 2002-05-10 Method replace(String, String, String) added.
 * <br>1.1 2002-02-05
 */
public class Strings extends Object {
    /**
     * Translates all occurences of characters in 
     * String 'from' to the characters in String 'to'.
     * This is a convenience method for calling
     * <code>translate(s, from.toCharArray(), to.toCharArray())</code>
     *
     * @param s The string to be translated.
     * @param from The characters to be replaced.
     * @param to   The replacement characters.
     *
     *
     * @return The translated String.
     */
    public static String translate(String s, String from, String to) {
        if (s == null) return null;
        return translate(s, from.toCharArray(), to.toCharArray());
    }

    /**
     * Translates all occurences of characters in the
     * char array 'from' to the characters in 'to'.
     *
     * @param s The string to be translated.
     * @param from The characters to be replaced.
     * @param to   The replacement characters.
     *
     * @return The translated String.
     */
    public static String translate(String s, char[] from, char[] to) {
        char[] map = new char[256];

        int i;

        for (i=0; i < 256; i++) {
            map[i] = (char) i;
        }

        for (i=0; i < from.length; i++) {
            map[from[i]] = to[i];
        }


        char[] result = new char[s.length()];
        for (i=0; i < result.length; i++) {
            result[i] = map[s.charAt(i)];
        }

        return new String(result);
    }

    /**
     * Replaces all occurences of 'from' by 'to'.
     *
     * @param str The string to be processed.
     * @param from The text to be replaced.
     * @param to   The replacement text.
     *
     * @return The translated String.
     */
    public static String replace(String str, String from, String to) {
        int p0 = 0, p1 = 0;
        StringBuffer buf = new StringBuffer();
        
        while ((p1 = str.indexOf(from, p0)) != -1) {
            buf.append(str.substring(p0, p1));
            buf.append(to);
            p0 = p1 + from.length();
        }
        buf.append(str.substring(p0, str.length()));
        
        return buf.toString();
    }
    
    /**
     * Splits a string using char d.
     */
    public static String[] split(String s, char d) {
        LinkedList<String> l = new LinkedList<String>();
        int beginIndex = 0;
        int endIndex;
        while ((endIndex = s.indexOf(d, beginIndex)) != -1) {
            l.add(s.substring(beginIndex, endIndex));
            beginIndex = endIndex + 1;
        }
        l.add(s.substring(beginIndex));
        return (String[]) l.toArray(new String[l.size()]);
    }
}
